<?php

class Fancybox_Widget extends WP_Widget
{

    function __construct() {
        parent::__construct(
            'fancybox_widget',
            esc_html__('* Fancy Box', 'murtes'),
            array('description' => esc_html__('Fancy Box Widget', 'murtes'),)
        );
    }

    function widget($args, $instance)
    {

        extract($args);

        $item_title = isset($instance['item_title']) ? (!empty($instance['item_title']) ? $instance['item_title'] : '') : '';
        $item_desc = isset($instance['item_desc']) ? (!empty($instance['item_desc']) ? $instance['item_desc'] : '') : '';
        $btn_text = isset($instance['btn_text']) ? (!empty($instance['btn_text']) ? $instance['btn_text'] : '') : '';
        $btn_link = isset($instance['btn_link']) ? (!empty($instance['btn_link']) ? $instance['btn_link'] : '') : '';
        $btn_link_target = isset($instance['btn_link_target']) ? (!empty($instance['btn_link_target']) ? $instance['btn_link_target'] : '') : '';
        $background_img_id = isset($instance['background_img']) ? (!empty($instance['background_img']) ? $instance['background_img'] : '') : '';
        $background_img_url = wp_get_attachment_image_url($background_img_id, '');
        ?>
        <div class="wg-fancybox">
            <div class="wg-fancybox-inner bg-image" style="background-image: url('<?php echo esc_url($background_img_url)?>');">
                <div class="wg-fancybox-body " >
                    <?php if (!empty($item_title)): ?>
                        <h4><?php echo wp_kses_post($item_title); ?></h4>
                    <?php endif; ?>
                    <?php if (!empty($item_desc)): ?>
                        <div class="wg-fancybox-desc">
                            <?php echo wp_kses_post($item_desc); ?>
                        </div>
                    <?php endif; ?>
                    <?php if (!empty($btn_text)) : ?>
                        <a class="wg-fancybox-button btn" href="<?php echo esc_url($btn_link); ?>" target="<?php echo esc_attr($btn_link_target); ?>"><?php echo esc_attr($btn_text); ?></a>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <?php
    }

    function update($new_instance, $old_instance)
    {
        $instance = $old_instance;
        $instance['title'] = strip_tags($new_instance['title']);
        $instance['item_title'] = strip_tags($new_instance['item_title']);
        $instance['sub_title'] = strip_tags($new_instance['sub_title']);
        $instance['item_desc'] = strip_tags($new_instance['item_desc']);
        $instance['btn_text'] = strip_tags($new_instance['btn_text']);
        $instance['btn_link'] = strip_tags($new_instance['btn_link']);
        $instance['btn_link_target'] = strip_tags($new_instance['btn_link_target']);
        $instance['background_img'] = strip_tags($new_instance['background_img']);
        return $instance;
    }

    function form($instance)
    {
        $title = isset($instance['title']) ? esc_attr($instance['title']) : '';
        $item_title = isset($instance['item_title']) ? esc_attr($instance['item_title']) : '';
        $sub_title = isset($instance['sub_title']) ? esc_attr($instance['sub_title']) : '';
        $item_desc = isset($instance['item_desc']) ? esc_attr($instance['item_desc']) : '';
        $btn_text = isset($instance['btn_text']) ? esc_attr($instance['btn_text']) : '';
        $btn_link = isset($instance['btn_link']) ? esc_attr($instance['btn_link']) : '';
        $btn_link_target = isset($instance['btn_link_target']) ? esc_attr($instance['btn_link_target']) : '_self';
        $background_img = isset($instance['background_img']) ? esc_attr($instance['background_img']) : '';
        ?>

        <div class="ct-wg-image-wrap">

            <label for="<?php echo esc_url($this->get_field_id('background_img')); ?>"><?php esc_html_e('Background Image', 'murtes'); ?></label>
            <input type="hidden" class="widefat hide-image-url"
                   id="<?php echo esc_attr($this->get_field_id('background_img')); ?>"
                   name="<?php echo esc_attr($this->get_field_name('background_img')); ?>"
                   value="<?php echo esc_attr($background_img) ?>"/>
            <div class="ct-wg-show-image">
                <?php
                if ($background_img != "") {
                    ?>
                    <img src="<?php echo wp_get_attachment_image_url($background_img) ?>">
                    <?php
                }
                ?>
            </div>
            <?php
            if ($background_img != "") {
                ?>
                <a href="#" class="ct-wg-select-image button" style="display: none;"><?php esc_html_e('Select Image', 'murtes'); ?></a>
                <a href="#" class="ct-wg-remove-image button"><?php esc_html_e('Remove Image', 'murtes'); ?></a>
                <?php
            } else {
                ?>
                <a href="#" class="ct-wg-select-image button"><?php esc_html_e('Select Image', 'murtes'); ?></a>
                <a href="#" class="ct-wg-remove-image button" style="display: none;"><?php esc_html_e('Remove Image', 'murtes'); ?></a>
                <?php
            }
            ?>
        </div>
        
        <p>
            <label for="<?php echo esc_url($this->get_field_id('item_title')); ?>"><?php esc_html_e('Item Title', 'murtes'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('item_title')); ?>"
                   name="<?php echo esc_attr($this->get_field_name('item_title')); ?>" type="text"
                   value="<?php echo esc_attr($item_title); ?>"/></p>

        <p>
            <label for="<?php echo esc_url($this->get_field_id('item_desc')); ?>"><?php esc_html_e('Description', 'murtes'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('item_desc')); ?>"
                   name="<?php echo esc_attr($this->get_field_name('item_desc')); ?>" type="text"
                   value="<?php echo esc_attr($item_desc); ?>"/></p>

        <p>
            <label for="<?php echo esc_url($this->get_field_id('btn_text')); ?>"><?php esc_html_e('Button Text', 'murtes'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('btn_text')); ?>"
                   name="<?php echo esc_attr($this->get_field_name('btn_text')); ?>" type="text"
                   value="<?php echo esc_attr($btn_text); ?>"/></p>

        <p>
            <label for="<?php echo esc_url($this->get_field_id('btn_link')); ?>"><?php esc_html_e('Button Link', 'murtes'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('btn_link')); ?>"
                   name="<?php echo esc_attr($this->get_field_name('btn_link')); ?>" type="text"
                   value="<?php echo esc_attr($btn_link); ?>"/></p>

        <p><label for="<?php echo esc_url($this->get_field_id('btn_link_target')); ?>"><?php esc_html_e( 'Button Link Target', 'murtes' ); ?></label>
         <select class="widefat" id="<?php echo esc_attr( $this->get_field_id('btn_link_target') ); ?>" name="<?php echo esc_attr( $this->get_field_name('btn_link_target') ); ?>">
            <option value="_self"<?php if( $btn_link_target == '_self' ){ echo 'selected="selected"';} ?>><?php esc_html_e('Self', 'murtes'); ?></option>
            <option value="_blank"<?php if( $btn_link_target == '_blank' ){ echo 'selected="selected"';} ?>><?php esc_html_e('Blank', 'murtes'); ?></option>
            <option value="_parent"<?php if( $btn_link_target == '_parent' ){ echo 'selected="selected"';} ?>><?php esc_html_e('Parent', 'murtes'); ?></option>
            <option value="_top"<?php if( $btn_link_target == '_top' ){ echo 'selected="selected"';} ?>><?php esc_html_e('Top', 'murtes'); ?></option>
         </select>
         </p>

        <?php
    }

}
function register_fancybox_widget() {
    if(function_exists('ct_allow_RegisterWidget')){
        ct_allow_RegisterWidget( 'Fancybox_Widget' );
    }
}
add_action('widgets_init', 'register_fancybox_widget');
?>