<?php
$atts_extra = shortcode_atts(array(
    'content_list'                  => '',
    'col_xl'               => 4,
    'col_lg'               => 4,
    'col_md'               => 3,
    'col_sm'               => 2,
    'col_xs'               => 1,
    'el_class'             => '',
    'animation'             => '',
    'img_size'             => '600x600',
    'button_text'             => '',
    'button_link'             => '',
    'hover_style'             => 'hover-primary',
), $atts);
$atts = array_merge($atts_extra, $atts);
extract($atts);
$animation_tmp = isset($animation) ? $animation : '';
$animation_classes = $this->getCSSAnimation( $animation_tmp );
$col_xl = 12 / $col_xl;
$col_lg = 12 / $col_lg;
$col_md = 12 / $col_md;
$col_sm = 12 / $col_sm;
$col_xs = 12 / $col_xs;
$grid_sizer = "col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
wp_enqueue_script('isotope');
wp_enqueue_script('imagesloaded');
wp_enqueue_script('murtes-isotope', get_template_directory_uri() . '/assets/js/isotope.ct.js', array('jquery'), '1.0.0', true);
$team_content_list = (array) vc_param_group_parse_atts( $content_list );
wp_enqueue_script( 'vc_waypoints' );
wp_enqueue_style( 'vc_animate-css' );
$btn_link = vc_build_link($button_link);
$btn_a_href = '#';
$btn_a_target = '_self';
if ( strlen( $btn_link['url'] ) > 0 ) {
    $btn_a_href = $btn_link['url'];
    $btn_a_target = strlen( $btn_link['target'] ) > 0 ? $btn_link['target'] : '_self';
}
?>

<div id="<?php echo esc_attr($html_id) ?>" class="ct-grid ct-grid-team1 <?php echo esc_attr($hover_style.' '.$el_class); ?>">

    <div class="ct-grid-inner ct-grid-masonry row animation-time" data-gutter="15">
        <div class="grid-sizer <?php echo esc_attr($grid_sizer); ?>"></div>
        <?php foreach ($team_content_list as $key => $value) {
            $title = isset($value['title']) ? $value['title'] : '';
            $position = isset($value['position']) ? $value['position'] : '';
            $item_link = isset($value['item_link']) ? $value['item_link'] : '';
            $link = vc_build_link($item_link);
            $a_href = '#';
            $a_target = '_self';
            if ( strlen( $link['url'] ) > 0 ) {
                $a_href = $link['url'];
                $a_target = strlen( $link['target'] ) > 0 ? $link['target'] : '_self';
            }
            $image = isset($value['image']) ? $value['image'] : '';
            $img = wpb_getImageBySize( array(
                'attach_id'  => $image,
                'thumb_size' => $img_size,
                'class'      => '',
            ));
            $thumbnail = $img['thumbnail'];
            $item_class = "grid-item col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
            ?>
            <div class="<?php echo esc_attr($item_class); ?>">
                <div class="grid-item-inner <?php echo esc_attr($animation_classes); ?>">
                    <?php if(!empty($image)) { ?>
                        <div class="team-featured">
                            <a href="<?php echo esc_url($a_href);?>" target="<?php  echo esc_attr($a_target); ?>"><?php echo wp_kses_post($thumbnail); ?></a>
                        </div>
                        <div class="team-holder">
                            <h3 class="team-title">
                                <a href="<?php echo esc_url($a_href);?>" target="<?php  echo esc_attr($a_target); ?>"><?php echo esc_attr($title); ?></a>
                            </h3>
                            <div class="team-position">
                                <?php echo esc_attr($position); ?>
                            </div>
                        </div>
                    <?php } ?>
                </div>
            </div>
        <?php } ?>
        <?php if(!empty($button_text)) : ?>
            <?php foreach ($team_content_list as $key => $value) {
                $image = isset($value['image']) ? $value['image'] : '';
                $img = wpb_getImageBySize( array(
                    'attach_id'  => $image,
                    'thumb_size' => $img_size,
                    'class'      => '',
                ));
                $thumbnail = $img['thumbnail'];
                $item_class = "grid-item col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
                ?>
                <?php if($key == 0 && !empty($image)) { ?>
                    <div class="<?php echo esc_attr($item_class); ?>">
                        <div class="grid-item-inner grid-item-detail <?php echo esc_attr($animation_classes); ?>">
                            <?php echo wp_kses_post($thumbnail); ?>
                            <div class="grid-item-detail-inner">
                                <a class="ct-button-plus" href="<?php echo esc_url($btn_a_href);?>" target="<?php  echo esc_attr($btn_a_target); ?>"><i class="icofont-plus"></i></a>
                                <div class="button-text"><?php echo esc_attr($button_text); ?></div>
                            </div>
                        </div>
                    </div>
                <?php } ?>
            <?php } ?>
        <?php endif; ?>
    </div>

</div>