<?php
extract(shortcode_atts(array(
    'ct_process_list' => '',
    'title_color' => '',
    'description_color' => '',
    'animation' => '',
    'el_class' => '',
    'col_xl'               => 4,
    'col_lg'               => 4,
    'col_md'               => 2,
    'col_sm'               => 2,
    'col_xs'               => 1,
), $atts));
$item_col_xl = 12 / $col_xl;
$item_col_lg = 12 / $col_lg;
$item_col_md = 12 / $col_md;
$item_col_sm = 12 / $col_sm;
$item_col_xs = 12 / $col_xs;
$grid_item = "col-xl-{$item_col_xl} col-lg-{$item_col_lg} col-md-{$item_col_md} col-sm-{$item_col_sm} col-{$item_col_xs}";
$ct_process = (array) vc_param_group_parse_atts($ct_process_list);
$animation_tmp = isset($animation) ? $animation : '';
$animation_classes = $this->getCSSAnimation( $animation_tmp );
$html_id = cmsHtmlID('ct-process');
if(!empty($ct_process)) : ?>
    <div id="<?php echo esc_attr($html_id);?>" class="ct-process-layout1 row process-<?php echo esc_attr($col_xl); ?>-columns <?php echo esc_attr( $el_class.' '.$animation_classes ); ?>">
        <?php foreach ($ct_process as $key => $value) {
            $title = isset($value['title']) ? $value['title'] : '';
            $description = isset($value['description']) ? $value['description'] : '';
            ?>
            <div class="ct-process-item <?php echo esc_attr($grid_item); ?>">
                <div class="ct-process-item-inner col-same-height">
                    <div class="item-count"><?php if($key < 9) { echo '0'; } echo esc_attr($key+1); ?></div>
                    <?php if($title):?>
                        <h3 class="ct-process-title" style="<?php if(!empty($title_color)) { echo 'color:'.esc_attr($title_color).';'; } ?>">
                            <?php echo apply_filters('the_title',$title);?>
                        </h3>
                    <?php endif;?>
                    <?php if(!empty($description)) : ?>
                        <div class="ct-process-desc" style="<?php if(!empty($description_color)) { echo 'color:'.esc_attr($description_color).';'; } ?>">
                            <?php echo wp_kses_post( $description ); ?>
                        </div>
                    <?php endif;?>
                </div>
            </div>
        <?php } ?>
    </div>
<?php endif; ?>