<?php
$atts_extra = shortcode_atts(array(
    'content_list'                  => '',
    'col_xl'               => 4,
    'col_lg'               => 4,
    'col_md'               => 3,
    'col_sm'               => 2,
    'col_xs'               => 1,
    'el_class'             => '',
    'animation'             => '',
    'img_size'             => '370x270',
), $atts);
$atts = array_merge($atts_extra, $atts);
extract($atts);
$animation_tmp = isset($animation) ? $animation : '';
$animation_classes = $this->getCSSAnimation( $animation_tmp );
$col_xl = 12 / $col_xl;
$col_lg = 12 / $col_lg;
$col_md = 12 / $col_md;
$col_sm = 12 / $col_sm;
$col_xs = 12 / $col_xs;
$grid_sizer = "col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
wp_enqueue_script('isotope');
wp_enqueue_script('imagesloaded');
wp_enqueue_script('murtes-isotope', get_template_directory_uri() . '/assets/js/isotope.ct.js', array('jquery'), '1.0.0', true);
$pricing_content_list = (array) vc_param_group_parse_atts( $content_list );
wp_enqueue_script( 'vc_waypoints' );
wp_enqueue_style( 'vc_animate-css' );
?>

<div id="<?php echo esc_attr($html_id) ?>" class="ct-grid ct-grid-pricing1 <?php echo esc_attr($el_class); ?>">

    <div class="ct-grid-inner ct-grid-masonry row animation-time" data-gutter="15">
        <div class="grid-sizer <?php echo esc_attr($grid_sizer); ?>"></div>
        <?php foreach ($pricing_content_list as $key => $value) {
            $title = isset($value['title']) ? $value['title'] : '';
            $price = isset($value['price']) ? $value['price'] : '';
            $time = isset($value['time']) ? $value['time'] : '';
            $content = isset($value['content']) ? $value['content'] : '';
            $featured = isset($value['featured']) ? $value['featured'] : '';
            $button_text = isset($value['button_text']) ? $value['button_text'] : '';
            $item_link = isset($value['item_link']) ? $value['item_link'] : '';
            $link = vc_build_link($item_link);
            $a_href = '#';
            $a_target = '_self';
            if ( strlen( $link['url'] ) > 0 ) {
                $a_href = $link['url'];
                $a_target = strlen( $link['target'] ) > 0 ? $link['target'] : '_self';
            }
            $content_child = (array) vc_param_group_parse_atts( $content );
            $item_class = "grid-item col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
            ?>
            <div class="<?php echo esc_attr($item_class); ?>">
                <div class="grid-item-inner <?php echo esc_attr($animation_classes); if(!empty($featured)) { echo esc_attr($featured); } ?>">
                    <div class="pricing-holder">
                        <h3 class="pricing-title">
                            <?php echo esc_attr($title); ?>
                        </h3>
                        <div class="pricing-meta">
                            <span class="pricing-price"><?php echo esc_attr($price); ?></span>
                            <?php if(!empty($time)) : ?>
                                <span class="pricing-time"><?php echo '/ '.esc_attr($time); ?></span>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="pricing-content">
                        <ul>
                            <?php foreach ($content_child as $key => $value) {
                                $content_item = isset($value['content_item']) ? $value['content_item'] : ''; ?>
                                <li><?php echo esc_attr($content_item); ?></li>
                            <?php } ?>
                        </ul>
                        <?php if(!empty($button_text)) : ?>
                            <div class="pricing-button">
                                <a class="btn btn-outline" href="<?php echo esc_url($a_href);?>" target="<?php  echo esc_attr($a_target); ?>"><?php echo esc_attr($button_text); ?></a>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php } ?>
    </div>

</div>