<?php
extract(shortcode_atts(array(
    'title' => '',
    'desc' => '',
    'button_text' => '',
    'button_link' => '',
    'icon_list' => 'fontawesome',
    'icon_fontawesome' => '',
    'icon_fontawesome5' => '',
    'icon_material_design' => '',
    'icon_etline' => '',
    'icon_flaticon' => '',
    'icon_themify' => '',
    'icon_weight' => '',
    'icon_position' => 'icon-right',
    'el_class' => '',
    'animation' => '',
    
), $atts));
$icon_name = "icon_" . $icon_list;
$icon_class = isset(${$icon_name}) ? ${$icon_name} : '';
$link = vc_build_link($button_link);
$a_href = '';
$a_target = '';
if ( strlen( $link['url'] ) > 0 ) {
    $a_href = $link['url'];
    $a_target = strlen( $link['target'] ) > 0 ? $link['target'] : '_self';
}
$animation_tmp = isset($animation) ? $animation : '';
$animation_classes = $this->getCSSAnimation( $animation_tmp );

?>
<div class="ct-cta-wrapper <?php echo esc_attr($el_class.' '.$animation_classes); ?>">
    <div class="ct-cta-inner">
        <div class="ct-cta-meta">
            <h3><?php echo wp_kses_post($title); ?></h3>
            <p><?php echo wp_kses_post($desc); ?></p>
        </div>
        <div class="ct-cta-button">
            <a class="btn btn-white" href="<?php echo esc_url($a_href);?>" target="<?php  echo esc_attr($a_target); ?>">
                <?php if($icon_class && $icon_position == 'icon-left'):?>
                    <i class="<?php echo esc_attr($icon_class.' '.$icon_position); ?> <?php if($icon_list == 'fontawesome5' && !empty($icon_weight)) { echo esc_attr($icon_weight); } ?>"></i>
                <?php endif; ?>
                <span><?php echo esc_attr($button_text); ?></span>
                <?php if($icon_class && $icon_position == 'icon-right'):?>
                    <i class="<?php echo esc_attr($icon_class.' '.$icon_position); ?> <?php if($icon_list == 'fontawesome5' && !empty($icon_weight)) { echo esc_attr($icon_weight); } ?>"></i>
                <?php endif; ?>
            </a>
        </div>
    </div>
</div>