<?php
$atts_extra = shortcode_atts(array(
    'content_list'                  => '',
    'col_xl'               => 4,
    'col_lg'               => 4,
    'col_md'               => 3,
    'col_sm'               => 2,
    'col_xs'               => 1,
    'el_class'             => '',
    'animation'             => '',
), $atts);
$atts = array_merge($atts_extra, $atts);
extract($atts);
$col_xl = 12 / $col_xl;
$col_lg = 12 / $col_lg;
$col_md = 12 / $col_md;
$col_sm = 12 / $col_sm;
$col_xs = 12 / $col_xs;
$case_study_content_list = (array) vc_param_group_parse_atts( $content_list );
$animation_tmp = isset($animation) ? $animation : '';
$animation_classes = $this->getCSSAnimation( $animation_tmp );
wp_enqueue_script( 'vc_waypoints' );
wp_enqueue_style( 'vc_animate-css' );
?>

<div id="<?php echo esc_attr($html_id) ?>" class="ct-case-study-detail1 <?php echo esc_attr($el_class); ?>">

    <div class="ct-grid-inner ct-grid-masonry row animation-time" data-gutter="15">
        <?php foreach ($case_study_content_list as $key => $value) {
            $title = isset($value['title']) ? $value['title'] : '';
            $content = isset($value['content']) ? $value['content'] : '';
            $icon_fontawesome5 = isset($value['icon_fontawesome5']) ? $value['icon_fontawesome5'] : '';
            $icon_weight = isset($value['icon_weight']) ? $value['icon_weight'] : '';
            $item_class = "grid-item col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
            ?>
            <div class="<?php echo esc_attr($item_class); ?>">
                <div class="grid-item-inner <?php echo esc_attr($animation_classes); ?>">
                    <?php if(!empty($icon_fontawesome5)) : ?>
                        <div class="case-study-icon">
                            <i class="<?php echo esc_attr($icon_fontawesome5); ?> <?php if(!empty($icon_weight)) { echo esc_attr($icon_weight); } ?>"></i>
                        </div>
                    <?php endif; ?>
                    <div class="case-study-meta">
                        <h3 class="case-study-title">
                            <?php echo esc_attr($title); ?>
                        </h3>
                        <div class="case-study-content"><?php echo wp_kses_post($content); ?></div>
                    </div>
                </div>
            </div>
        <?php } ?>
    </div>

</div>