<?php
vc_map(array(
    'name' => 'Video Player',
    'base' => 'ct_video_player',
    'class'    => 'ct-icon-element',
    'description' => 'Embed Youtube/Vimeo player',
    'category' => esc_html__('CaseThemes Shortcodes', 'murtes'),
    'params' => array(

        array(
            'type' => 'vc_link',
            'heading' => esc_html__( 'Video Url', 'murtes' ),
            'param_name' => 'video_link',
            'value' => 'https://www.youtube.com/watch?v=SF4aHwxHtZ0',
            'description' => 'Video url on Youtube, Vimeo'
        ),
        array(
            'type' => 'attach_image',
            'heading' => esc_html__( 'Video Intro', 'murtes' ),
            'param_name' => 'video_intro',
            'value' => '',
            'description' => esc_html__( 'Select intro image from media library.', 'murtes' ),
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Image size', 'murtes' ),
            'param_name' => 'img_size',
            'value' => '',
            'description' => esc_html__( 'Enter image size (Example: "thumbnail", "medium", "large", "full" or other sizes defined by theme). Alternatively enter size in pixels (Example: 200x100 (Width x Height).', 'murtes' ),
        ),
        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Button Video Style', 'murtes'),
            'param_name' => 'btn_video_style',
            'value' => array(
                'Style 1' => 'style1',
                'Style 2' => 'style2',
                'Style 3' => 'style3',
                'Style 4' => 'style4',
                'Style 5' => 'style5',
            ),
        ),

        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Video Intro Style', 'murtes'),
            'param_name' => 'intro_style',
            'value' => array(
                'Style 1' => 'style1',
                'Style 2' => 'style2',
                'Style 3' => 'style3',
                'Style 4' => 'style4',
                'Style 5' => 'style5',
                'Style 6' => 'style6',
                'Style 7' => 'style7',
            ),
        ),

        array(
            'type' => 'attach_image',
            'heading' => esc_html__( 'Video Intro Two', 'murtes' ),
            'param_name' => 'video_intro_two',
            'value' => '',
            'description' => esc_html__( 'Select intro image from media library.', 'murtes' ),
            'dependency' => array(
                'element'=>'intro_style',
                'value'=>array(
                    'style7',
                )
            ),
        ),

        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Extra class name', 'murtes' ),
            'param_name' => 'el_class',
            'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in Custom CSS.', 'murtes' ),
            'group'            => esc_html__('Extra', 'murtes')
        ),
        array(
            'type' => 'animation_style',
            'heading' => esc_html__( 'Animation Style', 'murtes' ),
            'param_name' => 'animation',
            'description' => esc_html__( 'Choose your animation style', 'murtes' ),
            'admin_label' => false,
            'weight' => 0,
            'group' => esc_html__('Extra', 'murtes'),
        ),
    )
));

class WPBakeryShortCode_ct_video_player extends CmsShortCode
{

    protected function content($atts, $content = null)
    {
        return parent::content($atts, $content);
    }
}

?>