<?php
$args = array(
    'name' => 'Testimonial Carousel',
    'base' => 'ct_testimonial_carousel',
    'class'    => 'ct-icon-element',
    'description' => esc_html__( 'Testimonial Carousel Displayed', 'murtes' ),
    'category' => esc_html__('CaseThemes Shortcodes', 'murtes'),
    'params' => array(

        /* Template */
        array(
            'type' => 'cms_template_img',
            'param_name' => 'cms_template',
            'shortcode' => 'ct_testimonial_carousel',
            'heading' => esc_html__('Shortcode Template', 'murtes'),
            'admin_label' => true,
            'group' => esc_html__('Template', 'murtes'),
            'std' => 'ct_testimonial_carousel.php'
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Extra class name', 'murtes' ),
            'param_name' => 'el_class',
            'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in Custom CSS.', 'murtes' ),
            'group'            => esc_html__('Template', 'murtes')
        ),
        /* Layout 1 */
        array(
            'type' => 'param_group',
            'heading' => esc_html__( 'Testimonial Item', 'murtes' ),
            'value' => '',
            'param_name' => 'testimonial_item',
            'dependency' => array(
                'element'=>'cms_template',
                'value'=>array(
                    'ct_testimonial_carousel.php',
                    'ct_testimonial_carousel--layout2.php',
                )
            ),
            'params' => array(
                array(
                    'type' => 'textfield',
                    'heading' =>esc_html__('Title', 'murtes'),
                    'param_name' => 'title',
                    'admin_label' => true,
                ),
                array(
                    'type' => 'textfield',
                    'heading' =>esc_html__('Position', 'murtes'),
                    'param_name' => 'position',
                    'admin_label' => true,
                ),
                array(
                    'type' => 'textarea',
                    'heading' => esc_html__('Content', 'murtes'),
                    'param_name' => 'content',
                ),
                array(
                    'type' => 'attach_image',
                    'heading' => esc_html__( 'Image', 'murtes' ),
                    'param_name' => 'image',
                    'value' => '',
                    'description' => esc_html__( 'Select image from media library. Default size: 370x440', 'murtes' ),
                ),
                array(
                    'type' => 'dropdown',
                    'heading' => esc_html__('Rating', 'murtes'),
                    'param_name' => 'rating',
                    'value' => array(
                        '5 Star' => 'star5',
                        '4 Star' => 'star4',
                        '3 Star' => 'star3',
                        '2 Star' => 'star2',
                        '1 Star' => 'star1',
                    ),
                ),
            ),
        ),
        array(
            'type' => 'colorpicker',
            'heading' => esc_html__('Title Color', 'murtes'),
            'param_name' => 'title_color',
            'value' => '',
        ),
        array(
            'type' => 'colorpicker',
            'heading' => esc_html__('Content Color', 'murtes'),
            'param_name' => 'content_color',
            'value' => '',
        ),
        array(
            'type' => 'colorpicker',
            'heading' => esc_html__('Position Color', 'murtes'),
            'param_name' => 'position_color',
            'value' => '',
        ),

    ));

$args = murtes_add_vc_extra_param($args);
vc_map($args);

class WPBakeryShortCode_ct_testimonial_carousel extends CmsShortCode
{

    protected function content($atts, $content = null)
    {
        return parent::content($atts, $content);
    }
}

?>