<?php
vc_map(array(
    'name' => 'Process',
    'base' => 'ct_process',
    'class'    => 'ct-icon-element',
    'description' => esc_html__( 'Process Displayed', 'murtes' ),
    'category' => esc_html__('CaseThemes Shortcodes', 'murtes'),
    'params' => array(

        array(
            'type' => 'param_group',
            'heading' => esc_html__( 'Process Lists', 'murtes' ),
            'param_name' => 'ct_process_list',
            'value' => '',
            'params' => array(
                /* Title */
                array(
                    'type' => 'textarea',
                    'heading' => esc_html__('Title', 'murtes'),
                    'param_name' => 'title',
                    'description' => 'Enter title.',
                    'admin_label' => true,
                ),

                /* Description */
                array(
                    'type' => 'textarea',
                    'heading' => esc_html__('Description', 'murtes'),
                    'param_name' => 'description',
                    'description' => 'Enter description.',
                ),
                
            ),
        ),

        array(
            'type'             => 'dropdown',
            'heading'          => esc_html__('Columns XS', 'murtes'),
            'param_name'       => 'col_xs',
            'edit_field_class' => 'vc_col-sm-1/5 vc_column',
            'value'            => array(1, 2, 3, 4, 6, 12),
            'std'              => 1,
        ),
        array(
            'type'             => 'dropdown',
            'heading'          => esc_html__('Columns SM', 'murtes'),
            'param_name'       => 'col_sm',
            'edit_field_class' => 'vc_col-sm-1/5 vc_column',
            'value'            => array(1, 2, 3, 4, 6, 12),
            'std'              => 2,
        ),
        array(
            'type'             => 'dropdown',
            'heading'          => esc_html__('Columns MD', 'murtes'),
            'param_name'       => 'col_md',
            'edit_field_class' => 'vc_col-sm-1/5 vc_column',
            'value'            => array(1, 2, 3, 4, 6, 12),
            'std'              => 2,
        ),
        array(
            'type'             => 'dropdown',
            'heading'          => esc_html__('Columns LG', 'murtes'),
            'param_name'       => 'col_lg',
            'edit_field_class' => 'vc_col-sm-1/5 vc_column',
            'value'            => array(1, 2, 3, 4, 6, 12),
            'std'              => 4,
        ),
        array(
            'type'             => 'dropdown',
            'heading'          => esc_html__('Columns XL', 'murtes'),
            'param_name'       => 'col_xl',
            'edit_field_class' => 'vc_col-sm-1/5 vc_column',
            'value'            => array(1, 2, 3, 4, 6, 12),
            'std'              => 4,
        ),

        /* Extra */
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Extra class name', 'murtes' ),
            'param_name' => 'el_class',
            'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in Custom CSS.', 'murtes' ),
            'group'            => esc_html__('Extra', 'murtes')
        ),
        array(
            'type' => 'animation_style',
            'heading' => esc_html__( 'Animation Style', 'murtes' ),
            'param_name' => 'animation',
            'description' => esc_html__( 'Choose your animation style', 'murtes' ),
            'admin_label' => false,
            'weight' => 0,
            'group' => esc_html__('Extra', 'murtes'),
        ),
    )
));

class WPBakeryShortCode_ct_process extends CmsShortCode
{

    protected function content($atts, $content = null)
    {
        return parent::content($atts, $content);
    }
}

?>