<?php
vc_map(array(
    "name" => 'Image Section',
    "base" => "ct_image_section",
    'class'    => 'ct-icon-element',
    'description' => esc_html__( 'Image Section', 'murtes' ),
    'category' => esc_html__('CaseThemes Shortcodes', 'murtes'),
    "params" => array(

        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Image Align', 'murtes'),
            'param_name' => 'image_align',
            'value' => array(
                'Grid Based' => 'grid-based',
                'Slide Based' => 'slide-based',
            ),
        ),
        array(
            'type' => 'attach_image',
            'heading' => esc_html__( 'Image', 'murtes' ),
            'param_name' => 'image',
            'value' => '',
            'description' => esc_html__( 'Select image from media library.', 'murtes' ),
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Position Top', 'murtes' ),
            'param_name' => 'p_top',
            'description' => esc_html__( 'Enter: ..px, ..%', 'murtes' ),
            'edit_field_class' => 'vc_col-sm-3 vc_column',
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Position Right', 'murtes' ),
            'param_name' => 'p_right',
            'description' => esc_html__( 'Enter: ..px, ..%', 'murtes' ),
            'edit_field_class' => 'vc_col-sm-3 vc_column',
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Position Bottom', 'murtes' ),
            'param_name' => 'p_bottom',
            'description' => esc_html__( 'Enter: ..px, ..%', 'murtes' ),
            'edit_field_class' => 'vc_col-sm-3 vc_column',
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Position Left', 'murtes' ),
            'param_name' => 'p_left',
            'description' => esc_html__( 'Enter: ..px, ..%', 'murtes' ),
            'edit_field_class' => 'vc_col-sm-3 vc_column',
        ),
        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Hide Tablet (991px > Device > 768px)', 'murtes'),
            'param_name' => 'hide_md',
            'value' => array(
                'No' => '',
                'Yes' => 'hidde-md',
            ),
            'edit_field_class' => 'vc_col-sm-6 vc_column',
        ),
        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Hide Mobile (Device < 767px)', 'murtes'),
            'param_name' => 'hide_sm',
            'value' => array(
                'No' => '',
                'Yes' => 'hidde-sm',
            ),
            'edit_field_class' => 'vc_col-sm-6 vc_column',
        ),

        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Parallax Mouse Move', 'murtes'),
            'param_name' => 'el_parallax',
            'value' => array(
                'No' => 'no',
                'Yes' => 'yes',
            ),
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__('Parallax Speed', 'murtes'),
            'param_name' => 'parallax_speed',
            'description' => 'Enter number. Default 5',
            'edit_field_class' => 'vc_col-sm-6 vc_column',
            'dependency' => array(
                'element'=>'el_parallax',
                'value'=>array(
                    'yes',
                )
            ),
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__('Parallax Move', 'murtes'),
            'param_name' => 'parallax_move',
            'description' => 'Enter number. Default 40',
            'edit_field_class' => 'vc_col-sm-6 vc_column',
            'dependency' => array(
                'element'=>'el_parallax',
                'value'=>array(
                    'yes',
                )
            ),
        ),

        /* Extra */
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Extra class name', 'murtes' ),
            'param_name' => 'el_class',
            'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in Custom CSS.', 'murtes' ),
            'group'            => esc_html__('Extra', 'murtes')
        ),
        array(
            'type' => 'animation_style',
            'heading' => esc_html__( 'Animation Style', 'murtes' ),
            'param_name' => 'animation',
            'description' => esc_html__( 'Choose your animation style', 'murtes' ),
            'admin_label' => false,
            'weight' => 0,
            "group" => esc_html__("Extra", 'murtes'),
        ),
    )
));

class WPBakeryShortCode_ct_image_section extends CmsShortCode
{

    protected function content($atts, $content = null)
    {
        return parent::content($atts, $content);
    }
}

?>