<?php
$args = array(
    'name' => 'Gallery Carousel',
    'base' => 'ct_gallery_carousel',
    'class'    => 'ct-icon-element',
    'description' => esc_html__( 'Gallery Displayed', 'murtes' ),
    'category' => esc_html__('CaseThemes Shortcodes', 'murtes'),
    'params' => array(

        array(
            'type' => 'attach_images',
            'heading' => esc_html__( 'Images', 'murtes' ),
            'param_name' => 'ct_images',
            'value' => '',
            'description' => esc_html__( 'Select images from media library.', 'murtes' ),
        ),

        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Image size', 'murtes' ),
            'param_name' => 'img_size',
            'value' => '',
            'description' => esc_html__( 'Enter image size (Example: "thumbnail", "medium", "large", "full" or other sizes defined by theme). Alternatively enter size in pixels (Example: 200x100 (Width x Height).', 'murtes' ),
        ),

        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Extra class name', 'murtes' ),
            'param_name' => 'el_class',
            'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in Custom CSS.', 'murtes' ),
        ),

        array(
            'type' => 'animation_style',
            'heading' => esc_html__( 'Animation Style', 'murtes' ),
            'param_name' => 'animation',
            'description' => esc_html__( 'Choose your animation style', 'murtes' ),
            'admin_label' => false,
            'weight' => 0,
        ),

    ));

$args = murtes_add_vc_extra_param($args);
vc_map($args);

class WPBakeryShortCode_ct_gallery_carousel extends CmsShortCode
{

    protected function content($atts, $content = null)
    {
        return parent::content($atts, $content);
    }
}

?>