<?php
$term_list = cms_get_grid_term_list('case-study');
vc_map(
    array(
        'name'     => esc_html__('Case Studies Grid', 'murtes'),
        'base'     => 'ct_case_study_grid',
        'class'    => 'ct-icon-element',
        'description' => esc_html__( 'Case study in masonry grid', 'murtes' ),
        'category' => esc_html__('CaseThemes Shortcodes', 'murtes'),
        'params'   => array(
            array(
                'type' => 'cms_template_img',
                'param_name' => 'cms_template',
                'shortcode' => 'ct_case_study_grid',
                'heading' => esc_html__('Shortcode Template', 'murtes'),
                'admin_label' => true,
                'std' => 'ct_case_study_grid.php',
                'group' => esc_html__('Template', 'murtes'),
            ),
            array(
                'type'       => 'checkbox',
                'heading'    => esc_html__('Custom Source', 'murtes'),
                'param_name' => 'custom_source',
                'value'      => '1',
                'description'        => 'Check here if you want custom source',
                'group'      => esc_html__('Source Settings', 'murtes')
            ),
            array(
                'type'       => 'autocomplete',
                'heading'    => esc_html__('Select Categories', 'murtes'),
                'param_name' => 'source',
                'description' => esc_html__('Leave blank to select all category', 'murtes'),
                'settings'   => array(
                    'multiple' => true,
                    'values'   => $term_list['auto_complete'],
                ),
                'dependency' => array(
                    'element'=>'custom_source',
                    'value'=>array(
                        'true',
                    )
                ),
                'group'      => esc_html__('Source Settings', 'murtes'),
            ),
            array(
                'type'       => 'autocomplete',
                'class'      => '',
                'heading'    => esc_html__('Select Post Name', 'murtes'),
                'param_name' => 'post_ids',
                'description' => esc_html__('Leave blank to show all post', 'murtes'),
                'settings'   => array(
                    'multiple' => true,
                    'values'   => cms_get_type_posts_data('case-study')
                ),
                'dependency' => array(
                    'element'=>'custom_source',
                    'value'=>array(
                        'true',
                    )
                ),
                'group'      => esc_html__('Source Settings', 'murtes'),
            ),
            array(
                'type'       => 'dropdown',
                'heading'    => esc_html__('Order by', 'murtes'),
                'param_name' => 'orderby',
                'value'      => array(
                    'Date'   => 'date',
                    'ID'     => 'ID',
                    'Author' => 'author',
                    'Title'  => 'title',
                    'Random' => 'rand',
                ),
                'std'        => 'date',
                'group'      => esc_html__('Source Settings', 'murtes')
            ),
            array(
                'type'       => 'dropdown',
                'heading'    => esc_html__('Sort order', 'murtes'),
                'param_name' => 'order',
                'value'      => array(
                    'Ascending'  => 'ASC',
                    'Descending' => 'DESC',
                ),
                'std'        => 'DESC',
                'group'      => esc_html__('Source Settings', 'murtes')
            ),
            array(
                'type'       => 'textfield',
                'heading'    => esc_html__('Total items', 'murtes'),
                'param_name' => 'limit',
                'value'      => '6',
                'group'      => esc_html__('Source Settings', 'murtes'),
                'description' => esc_html__('Set max limit for items in grid. Enter number only', 'murtes'),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Length of excerpt', 'murtes' ),
                'param_name' => 'length_excerpt',
                'value' => '',
                'group'      => esc_html__('Source Settings', 'murtes'),
                'dependency' => array(
                    'element'=>'cms_template',
                    'value'=>array(
                        'ct_case_study_grid.php',
                    )
                ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Image size', 'murtes' ),
                'param_name' => 'img_size',
                'value' => '',
                'description' => esc_html__( 'Enter image size (Example: "thumbnail", "medium", "large", "full" or other sizes defined by theme). Alternatively enter size in pixels (Example: 200x100 (Width x Height). Enter multiple sizes (Example: 100x100,200x200,300x300)).', 'murtes' ),
                'group'      => esc_html__('Grid Settings', 'murtes'),
                'dependency' => array(
                    'element'=>'cms_template',
                    'value'=>array(
                        'ct_case_study_grid.php',
                    )
                ),
            ),
            array(
                'type'       => 'dropdown',
                'heading'    => esc_html__('Filter on Masonry', 'murtes'),
                'param_name' => 'filter',
                'value'      => array(
                    'Disable' => 'false',
                    'Enable'  => 'true',
                ),
                'dependency' => array(
                    'element' => 'layout',
                    'value'   => 'masonry'
                ),
                'group'      => esc_html__('Grid Settings', 'murtes'),
                'dependency' => array(
                    'element'=>'cms_template',
                    'value'=>array(
                        'ct_case_study_grid.php',
                    )
                ),
            ),
            array(
                'type'       => 'dropdown',
                'heading'    => esc_html__('Pagination Type', 'murtes'),
                'param_name' => 'pagination_type',
                'value'      => array(
                    'Disable' => 'false',
                    'Pagination'  => 'pagination',
                    'Loadmore' => 'loadmore',
                ),
                'dependency' => array(
                    'element' => 'layout',
                    'value'   => 'masonry'
                ),
                'group'      => esc_html__('Grid Settings', 'murtes'),
            ),
            array(
                'type'       => 'textfield',
                'heading'    => esc_html__('Default Title', 'murtes'),
                'param_name' => 'filter_default_title',
                'value'      => 'All',
                'group'      => esc_html__('Filter', 'murtes'),
                'description' => esc_html__('Enter default title for filter option display, empty: All', 'murtes'),
                'dependency' => array(
                    'element' => 'filter',
                    'value'   => 'true'
                ),
            ),
            array(
                'type'       => 'textfield',
                'heading'    => esc_html__('Item Gap', 'murtes'),
                'param_name' => 'gap',
                'value'      => '30',
                'group'      => esc_html__('Grid Settings', 'murtes'),
                'description' => esc_html__('Select gap between grid elements. Enter number only', 'murtes'),
                'dependency' => array(
                    'element'=>'cms_template',
                    'value'=>array(
                        'ct_case_study_grid.php',
                    )
                ),
            ),
            array(
                'type'             => 'dropdown',
                'heading'          => esc_html__('Columns XS', 'murtes'),
                'param_name'       => 'col_xs',
                'edit_field_class' => 'vc_col-sm-1/5 vc_column',
                'value'            => array(1, 2, 3, 4, 6, 12),
                'std'              => 1,
                'group'            => esc_html__('Grid Settings', 'murtes'),
                'dependency' => array(
                    'element'=>'cms_template',
                    'value'=>array(
                        'ct_case_study_grid.php',
                    )
                ),
            ),
            array(
                'type'             => 'dropdown',
                'heading'          => esc_html__('Columns SM', 'murtes'),
                'param_name'       => 'col_sm',
                'edit_field_class' => 'vc_col-sm-1/5 vc_column',
                'value'            => array(1, 2, 3, 4, 6, 12),
                'std'              => 2,
                'group'            => esc_html__('Grid Settings', 'murtes'),
                'dependency' => array(
                    'element'=>'cms_template',
                    'value'=>array(
                        'ct_case_study_grid.php',
                    )
                ),
            ),
            array(
                'type'             => 'dropdown',
                'heading'          => esc_html__('Columns MD', 'murtes'),
                'param_name'       => 'col_md',
                'edit_field_class' => 'vc_col-sm-1/5 vc_column',
                'value'            => array(1, 2, 3, 4, 6, 12),
                'std'              => 3,
                'group'            => esc_html__('Grid Settings', 'murtes'),
                'dependency' => array(
                    'element'=>'cms_template',
                    'value'=>array(
                        'ct_case_study_grid.php',
                    )
                ),
            ),
            array(
                'type'             => 'dropdown',
                'heading'          => esc_html__('Columns LG', 'murtes'),
                'param_name'       => 'col_lg',
                'edit_field_class' => 'vc_col-sm-1/5 vc_column',
                'value'            => array(1, 2, 3, 4, 6, 12),
                'std'              => 4,
                'group'            => esc_html__('Grid Settings', 'murtes'),
                'dependency' => array(
                    'element'=>'cms_template',
                    'value'=>array(
                        'ct_case_study_grid.php',
                    )
                ),
            ),
            array(
                'type'             => 'dropdown',
                'heading'          => esc_html__('Columns XL', 'murtes'),
                'param_name'       => 'col_xl',
                'edit_field_class' => 'vc_col-sm-1/5 vc_column',
                'value'            => array(1, 2, 3, 4, 6, 12),
                'std'              => 4,
                'group'            => esc_html__('Grid Settings', 'murtes'),
                'dependency' => array(
                    'element'=>'cms_template',
                    'value'=>array(
                        'ct_case_study_grid.php',
                    )
                ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Extra class name', 'murtes' ),
                'param_name' => 'el_class',
                'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in Custom CSS.', 'murtes' ),
                'group'            => esc_html__('Extra', 'murtes')
            ),
            array(
                'type' => 'animation_style',
                'heading' => esc_html__( 'Animation Style', 'murtes' ),
                'param_name' => 'animation',
                'description' => esc_html__( 'Choose your animation style', 'murtes' ),
                'admin_label' => false,
                'weight' => 0,
                'group' => esc_html__('Extra', 'murtes'),
            ),
        )
    )
);

class WPBakeryShortCode_ct_case_study_grid extends CmsShortCode
{
    protected function content($atts, $content = null)
    {
        $html_id = cmsHtmlID('ct-case-study-grid');
        $atts['html_id'] = $html_id;
        return parent::content($atts, $content);
    }
}

?>