jQuery(function($) {
	"use strict";
	setTimeout(function(){
		$(".ct-counter-digit").each( function() {
			"use strict";
			var options = {
				useEasing : true,
				useGrouping : ($(this).attr('data-grouping')) == '1' ? true : false,
				separator : $(this).attr('data-separator'),
				decimal : '.'
			}
			var digit = $(this).attr("data-digit");
			var prefix = $(this).attr("data-prefix");
			var suffix = $(this).attr("data-suffix");
			if (prefix != undefined) {
				options.prefix = '<span>'+prefix+'</span>';
			}
			if (suffix != undefined) {
				options.suffix = '<span>'+suffix+'</span>';
			}
			var random = 0;
			if ($(this).attr("data-type") == 'random') {
				var random = Math.floor(Math.random() * digit * 2);
			}
			$(this).waypoint(
				function() {
					var count = new countUp($(this).attr("id"), random,
						digit, 0, 0, options);
					count.start();
				}, {
					offset : '95%',
					triggerOnce : true
				});
		});
	}, 300);
});
